<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Roleta Russa Numérica</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 0;
            background-color: #f7f7f7;
        }
        h1 {
            color: #333;
            margin-top: 20px;
        }
        #status, #ultimos-numeros {
            font-size: 18px;
            margin: 20px 0;
            color: #555;
        }
        button {
            padding: 10px 20px;
            font-size: 16px;
            color: white;
            background-color: #e63946;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #d62828;
        }
        #play-again {
            display: none;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <h1>Roleta Russa Numérica</h1>
    <p id="status">Clique no botão para girar a roleta...</p>
    <button id="spin" onclick="girarRoleta()">Girar Roleta</button>
    <button id="play-again" onclick="resetarJogo()">Jogar Novamente</button>
    <div id="ultimos-numeros"></div>

    <script>
        let numeroFatal;
        let jogoAtivo = true;
        let numerosSorteados = [];

        function iniciarJogo() {
            // Define um número fatal entre 0 e 36
            numeroFatal = Math.floor(Math.random() * 37);
            numerosSorteados = []; // Reseta os números sorteados
            jogoAtivo = true;
            console.log(`Número fatal (oculto): ${numeroFatal}`); // Para debug
            atualizarStatus("Clique no botão para girar a roleta...");
            atualizarUltimosNumeros();
        }

        function girarRoleta() {
            if (!jogoAtivo) return;

            // Checar se ainda há números disponíveis
            if (numerosSorteados.length >= 37) {
                atualizarStatus("Todos os números já foram sorteados! Reinicie o jogo.");
                finalizarJogo();
                return;
            }

            // Sorteia um número único
            let numeroSorteado;
            do {
                numeroSorteado = Math.floor(Math.random() * 37);
            } while (numerosSorteados.includes(numeroSorteado));

            numerosSorteados.push(numeroSorteado); // Registra o número sorteado

            if (numeroSorteado === numeroFatal) {
                atualizarStatus(`💥 O número sorteado foi ${numeroSorteado}. Você perdeu!`);
                atualizarUltimosNumeros();
                finalizarJogo();
            } else {
                const restantes = 37 - numerosSorteados.length;
                atualizarStatus(`O número sorteado foi ${numeroSorteado}. Você ainda está no jogo! Restam ${restantes} números.`);
                atualizarUltimosNumeros();
            }
        }

        function atualizarStatus(mensagem) {
            document.getElementById('status').innerText = mensagem;
        }

        function atualizarUltimosNumeros() {
            const ultimosNumeros = numerosSorteados.slice(-10).reverse(); // Pega os últimos 10 números em ordem reversa
            document.getElementById('ultimos-numeros').innerHTML = 
                `<strong>Últimos números sorteados:</strong> ${ultimosNumeros.join(', ')}`;
        }

        function finalizarJogo() {
            jogoAtivo = false;
            document.getElementById('spin').style.display = "none";
            document.getElementById('play-again').style.display = "inline-block";
        }

        function resetarJogo() {
            iniciarJogo();
            document.getElementById('spin').style.display = "inline-block";
            document.getElementById('play-again').style.display = "none";
        }

        // Inicializa o jogo
        iniciarJogo();
    </script>
</body>
</html>

